<?php

namespace ZPOS;

class API
{
	public function __construct()
	{
		add_action('rest_api_init', [$this, 'register_rest_routes'], 5);
	}

	public function register_rest_routes()
	{
		if (Frontend::checkUserAssign()) {
			// need check debug mode to prevent errors
			wp_debug_mode();

			$classes = [
				API\Applications::class,
				API\Application::class,
				API\Products::class,
				API\ProductVariations::class,
				API\Coupons::class,
				API\Cart::class,
				API\TaxClasses::class,
				API\Taxes::class,
				API\Categories::class,
				API\Groups::class,
				API\Gateways::class,
				API\Orders::class,
				API\Settings::class,
				API\Setting\Option::class,
				API\Customers::class,
				API\PrintLocation::class,
			];

			foreach ($classes as $class) {
				/* @var $controller \WP_REST_Controller */
				$controller = new $class();
				$controller->register_routes();
			}
		} else {
			$this->rewrite_rest_routes();
		}
	}

	public static function get_raw_data()
	{
		global $HTTP_RAW_POST_DATA;
		if (!isset($HTTP_RAW_POST_DATA)) {
			$HTTP_RAW_POST_DATA = trim(file_get_contents('php://input'));
		}
		return json_decode($HTTP_RAW_POST_DATA, true);
	}

	public static function is_pos()
	{
		return isset($_SERVER['HTTP_X_POS']) && $_SERVER['HTTP_X_POS'];
	}

	public function rewrite_rest_routes()
	{
		register_rest_route(REST_NAMESPACE, '/(.+)', [
			'callback' => [$this, 'error'],
		]);
	}

	public function error()
	{
		return rest_ensure_response(
			new \WP_REST_Response(
				[
					'message' => __(
						'Change your User Assignments to access the POS system.',
						'point-of-sale-pos-woocommerce'
					),
					'title' => __('User Assignments Error', 'point-of-sale-pos-woocommerce'),
					'code' => 'reload',
					'button' => [
						'link' => add_query_arg('page', 'pos#/users', admin_url('admin.php')),
						'title' => __('Go to User Assignment Settings', 'point-of-sale-pos-woocommerce'),
					],
				],
				402
			)
		);
	}
}
