<?php

namespace ZPOS\API;

use WP_REST_Server, WC_REST_Product_Categories_Controller;
use const ZPOS\REST_NAMESPACE;
use ZPOS\Structure\AddDefaultImage;

class Categories extends WC_REST_Product_Categories_Controller
{
	use AddDefaultImage;

	protected $namespace = REST_NAMESPACE;

	public function __construct()
	{
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
		add_filter("woocommerce_rest_prepare_{$this->taxonomy}", [$this, 'add_default_image'], 1000);
	}

	public function register_routes()
	{
		parent::register_routes();
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
		register_rest_route($this->namespace, '/' . $this->rest_base . '/ids', array(
			'methods' => WP_REST_Server::READABLE,
			'callback' => array($this, 'get_all_ids'),
			'permission_callback' => array($this, 'get_items_permissions_check'),
		));
	}

	public function get_all_ids()
	{
		return array_map(function ($term) {
			return $term->term_id;
		}, get_terms($this->taxonomy));
	}

	public function get_items_permissions_check($request)
	{
		return parent::get_items_permissions_check($request) ||
			current_user_can('read_woocommerce_pos_categories');
	}
}
