<?php

namespace ZPOS\API;

use WP_REST_Server, WC_REST_Coupons_Controller;
use const ZPOS\REST_NAMESPACE;

class Coupons extends WC_REST_Coupons_Controller
{
	protected $namespace = REST_NAMESPACE;
	protected $rest_base = 'coupons';

	public function __construct()
	{
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
	}

	public function register_routes()
	{
		parent::register_routes();
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
		register_rest_route($this->namespace, '/' . $this->rest_base . '/ids', array(
			'methods' => WP_REST_Server::READABLE,
			'callback' => array($this, 'get_all_ids'),
			'permission_callback' => array($this, 'get_items_permissions_check'),
		));

		register_rest_route($this->namespace, '/' . $this->rest_base . '/(?P<code>[\w]+)', array(
			'args' => array(
				'code' => array(
					'description' => __('Unique identifier for the resource.', 'woocommerce'),
					'type' => 'string',
				),
			),
			array(
				'methods' => WP_REST_Server::READABLE,
				'callback' => array($this, 'get_single_item'),
				'permission_callback' => array($this, 'get_single_item_permissions_check'),
				'args' => array(
					'context' => $this->get_context_param(array('default' => 'view')),
				),
			),
		));
	}

	public function get_all_ids()
	{
		$args = array(
			'post_type' => array($this->post_type),
			'post_status' => array('publish'),
			'posts_per_page' => -1,
			'fields' => 'ids',
			'order' => isset($filter['order']) ? $filter['order'] : 'ASC',
			'orderby' => isset($filter['orderby']) ? $filter['orderby'] : 'title',
		);

		if (isset($filter['updated_at_min'])) {
			$args['date_query'][] = array(
				'column' => 'post_modified',
				'after' => $filter['updated_at_min'],
				'inclusive' => false,
			);
		}

		$query = new \WP_Query($args);
		return rest_ensure_response($query->posts);
	}

	public function get_single_item($request)
	{
		$object = $this->get_object($request['code']);

		if (!$object || 0 === $object->get_id()) {
			return new \WP_Error(
				"woocommerce_rest_{$this->post_type}_invalid_code",
				__('Invalid Coupon Code.', 'woocommerce'),
				array('status' => 404)
			);
		}

		$data = $this->prepare_object_for_response($object, $request);
		$response = rest_ensure_response($data);

		if ($this->public) {
			$response->link_header('alternate', $this->get_permalink($object), array(
				'type' => 'text/html',
			));
		}

		return $response;
	}

	public function get_single_item_permissions_check()
	{
		return current_user_can('read_woocommerce_pos_single_coupons');
	}

	public function prepare_objects_query($request)
	{
		$args = parent::prepare_objects_query($request);

		$meta_query = [];
		if (isset($request['pos'])) {
			$meta_query[] = [
				'key' => '_pos',
				'value' => 'true',
			];
		}

		if (isset($request['type'])) {
			$meta_query[] = [
				'key' => 'discount_type',
				'value' => $request['type'],
			];
		}

		if (isset($request['amount'])) {
			$meta_query[] = [
				'key' => 'coupon_amount',
				'value' => $request['amount'],
			];
		}

		if (count($meta_query) > 0) {
			$args['meta_query'] = $meta_query;
		}

		return $args;
	}
}
