<?php

namespace ZPOS\API;

use WP_REST_Server, WC_REST_Payment_Gateways_Controller, ZPOS\Model\Gateway;
use const ZPOS\REST_NAMESPACE;

class Gateways extends WC_REST_Payment_Gateways_Controller
{
	protected $namespace = REST_NAMESPACE;

	public function __construct()
	{
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
	}

	public function register_routes()
	{
		do_action(__METHOD__, $this, $this->namespace, $this->rest_base);
		register_rest_route($this->namespace, '/' . $this->rest_base . '/ids', array(
			'methods' => WP_REST_Server::READABLE,
			'callback' => array($this, 'get_all_ids'),
		));
		parent::register_routes();
	}

	public function get_all_ids()
	{
		return array_keys(
			WC()
				->payment_gateways()
				->payment_gateways()
		);
	}

	public function get_items($request)
	{
		$payment_gateways = WC()->payment_gateways->payment_gateways();
		$response = array();
		foreach ($payment_gateways as $payment_gateway_id => $payment_gateway) {
			$payment_gateway->id = $payment_gateway_id;
			$gateway = $this->prepare_item_for_response($payment_gateway, $request);
			$gateway = $this->prepare_response_for_collection($gateway);
			$response[] = $gateway;
		}

		return rest_ensure_response($response);
	}

	public function prepare_item_for_response($payment_gateway, $request)
	{
		$gateway = parent::prepare_item_for_response($payment_gateway, $request);
		$data = $gateway->data;
		$gateway->data['order'] = $this->get_order($data);
		$gateway->data['pos'] = Gateway::is_gateway_enabled($data['id']);
		$gateway->data['kiosk'] = $payment_gateway->supports('kiosk');
		$gateway->data['settings'] = method_exists($payment_gateway, 'rest_filter_settings')
			? $payment_gateway->rest_filter_settings($gateway->data['settings'])
			: $gateway->data['settings'];
		$gateway->data['default'] = get_option('pos_gateways_default') === $data['id'];

		return $gateway;
	}

	private function get_order($gateway)
	{
		$gateways_data = get_option('pos_gateways');
		$order = isset($gateways_data[$gateway['id']])
			? (int) $gateways_data[$gateway['id']]["order"]
			: 9999;
		return $order;
	}

	public function get_items_permissions_check($request)
	{
		return parent::get_item_permissions_check($request) ||
			current_user_can('read_woocommerce_pos_gateways');
	}
}
