<?php

namespace ZPOS\Admin\Stations\Tabs;

use ZPOS\Admin\Setting\Box;
use ZPOS\Admin\Setting\Input\AssocArray;
use ZPOS\Admin\Setting\Input\Checkbox;
use ZPOS\Admin\Setting\Input\Number;
use ZPOS\Admin\Setting\Input\Radio;
use ZPOS\Admin\Setting\PostTab;
use ZPOS\Admin\Setting\Sanitize\Boolean;

class Products extends PostTab
{
	use Boolean;

	public $name;
	public $path = '/products';

	public function __construct()
	{
		parent::__construct();
		$this->name = __('Products', 'point-of-sale-pos-woocommerce');
	}

	public function getBoxes()
	{
		return [
			new Box(
				__('Inventory Management', 'point-of-sale-pos-woocommerce'),
				null,
				new Radio(
					__('Stock Management Functionality', 'point-of-sale-pos-woocommerce'),
					'pos_inventory_management',
					$this->getValue('pos_inventory_management'),
					[
						[
							'value' => 'block',
							'label' => __(
								'Reduce stock and block POS from ordering out of stock products',
								'point-of-sale-pos-woocommerce'
							),
						],
					],
					[
						'description' => __(
							'Enabled only when Woocommerce Inventory Management is active',
							'point-of-sale-pos-woocommerce'
						),
						'descriptionPosition' => 'nextToLabel',
					]
				),
				new Checkbox(
					null,
					'pos_hide_out_of_stock_products',
					$this->getValue('pos_hide_out_of_stock_products'),
					__('Hide out of stock products from POS product list', 'point-of-sale-pos-woocommerce')
				),
				new Radio(
					null,
					'pos_inventory_management',
					$this->getValue('pos_inventory_management'),
					[
						[
							'value' => 'allow',
							'label' => __(
								'Reduce stock and allow POS to order out of stock products',
								'point-of-sale-pos-woocommerce'
							),
						],
					],
					['savePost' => null]
				),
				new Number(null, 'pos_hold_stock', $this->getValue('pos_hold_stock'), [
					'title' => __('Hold stock (minutes)', 'point-of-sale-pos-woocommerce'),
					'inputDescription' => __(
						'Hold stock (for products placed in cart) for x minutes. When this limit is reached, the stock will be released. Leave blank to disable.',
						'point-of-sale-pos-woocommerce'
					),
				])
			),
			new Box(
				__('Coupons', 'point-of-sale-pos-woocommerce'),
				null,
				new Checkbox(
					null,
					'pos_coupons_manual',
					$this->getValue('pos_coupons_manual'),
					__('Enable Manual Coupons', 'point-of-sale-pos-woocommerce'),
					[
						'sanitize' => [$this, 'sanitizeBoolean'],
					]
				)
			),
			new Box(
				__('Tiles', 'point-of-sale-pos-woocommerce'),
				null,
				new Checkbox(
					null,
					'pos_show_photo_in_tile',
					$this->getValue('pos_show_photo_in_tile'),
					__('Show Photo in Tile', 'point-of-sale-pos-woocommerce'),
					[
						'afterHeading' => true,
						'description' => __(
							'Note: Product and Category photo tile display may impact POS loading performance',
							'point-of-sale-pos-woocommerce'
						),
						'sanitize' => [$this, 'sanitizeBoolean'],
					]
				)
			),
			new Box(
				__('Product Tabs', 'point-of-sale-pos-woocommerce'),
				null,
				new AssocArray(null, 'pos_tabs', $this->getValue('pos_tabs'), [
					'sanitize' => [$this, 'sanitizeTabs'],
				])
			),
		];
	}

	public static function getDefaultValue($value, $post, $name)
	{
		switch ($name) {
			case 'pos_tabs':
				return [
					'all' => 'Products',
					'cat-list' => 'Categories',
				];
			case 'pos_coupons_manual':
			case 'pos_show_photo_in_tile':
				return false;
			default:
				return $value;
		}
	}

	public static function sanitizeTabs($raw_data)
	{
		$data = [];

		foreach ($raw_data as $el) {
			$data[$el['key']] = $el['value'];
		}

		return $data;
	}
}
