<?php

namespace ZPOS\Gateway;

use WC_Order;
use ZPOS\API;

class Cash extends Base
{
	public $id = 'pos_cash';
	public $method_title = 'Cash';
	public $method_description = '';
	public $has_fields = true;
	public $supports = array('products', 'pos');

	public function __construct()
	{
		parent::__construct();

		$this->title = $this->get_option('title');
		$this->description = $this->get_option('description');

		// Actions
		add_action('woocommerce_pos_update_options_payment_gateways_' . $this->id, array(
			$this,
			'process_admin_options',
		));
		add_action('woocommerce_thankyou_pos_cash', array($this, 'calculate_change'));
	}

	public function payment_fields()
	{
		if ($this->description) {
			echo '<p>' . wp_kses_post($this->description) . '</p>';
		}

		$currency_pos = get_option('woocommerce_currency_pos');

		if ($currency_pos == 'left' || 'left_space') {
			$left_addon =
				'<span class="input-group-addon">' .
				get_woocommerce_currency_symbol(get_woocommerce_currency()) .
				'</span>';
			$right_addon = '';
		} else {
			$left_addon = '';
			$right_addon =
				'<span class="input-group-addon">' .
				get_woocommerce_currency_symbol(get_woocommerce_currency()) .
				'</span>';
		}

		echo '
      <div class="form-row" id="pos-cash-tendered_field">
        <label for="pos-cash-tendered" class="">' .
			__('Amount Tendered', 'point-of-sale-pos-woocommerce') .
			'</label>
        <div class="input-group">
        ' .
			$left_addon .
			'
          <input type="text" class="form-control" name="pos-cash-tendered" id="pos-cash-tendered" maxlength="20" data-numpad="cash" data-label="' .
			__('Amount Tendered', 'point-of-sale-pos-woocommerce') .
			'" data-placement="bottom" data-value="{{total}}">
        ' .
			$right_addon .
			'
        </div>
      </div>
    ';
	}

	public function process_payment($order_id)
	{
		// get order object
		$order = new WC_Order($order_id);

		// update pos_cash data
		$data = API::get_raw_data();
		$tendered = isset($data['payment_details']['pos-cash-tendered'])
			? wc_format_decimal($data['payment_details']['pos-cash-tendered'])
			: 0;
		$change = isset($data['payment_details']['pos-cash-change'])
			? wc_format_decimal($data['payment_details']['pos-cash-change'])
			: 0;
		update_post_meta($order_id, '_pos_cash_amount_tendered', $tendered);
		update_post_meta($order_id, '_pos_cash_change', $change);

		if (isset($data['payment_details']['paid']) && $data['payment_details']['paid']) {
			// payment complete
			$order->update_status('processing');
			return array(
				'result' => 'success',
			);
		} else {
			return array(
				'result' => 'failed',
			);
		}
	}

	public function calculate_change($order_id)
	{
		$message = '';
		$tendered = get_post_meta($order_id, '_pos_cash_amount_tendered', true);
		$change = get_post_meta($order_id, '_pos_cash_change', true);

		// construct message
		if ($tendered && $change) {
			$message = __('Amount Tendered', 'point-of-sale-pos-woocommerce') . ': ';
			$message .= wc_price($tendered) . '<br>';
			$message .=
				_x('Change', 'Money returned from cash sale', 'point-of-sale-pos-woocommerce') . ': ';
			$message .= wc_price($change);
		}

		echo $message;
	}

	public static function payment_details($order)
	{
		return array(
			'tendered' => get_post_meta($order->id, '_pos_cash_amount_tendered', true),
			'change' => get_post_meta($order->id, '_pos_cash_change', true),
		);
	}
}
