<?php

namespace ZPOS\Gateway\Stripe;
require_once __DIR__ . '/api/init.php';

class API
{
	private static $_instance = null;

	private function __construct()
	{
		$stripe = new \WC_Gateway_Stripe();
		$settings = $stripe->settings;

		if ($settings['testmode'] === 'yes') {
			$settings['secret_key'] = $settings['test_secret_key'];
		}

		\Stripe\Stripe::setApiKey($settings['secret_key']);
	}

	protected function __clone()
	{
	}

	public static function instance()
	{
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function createCharge($token, $amount, $currency, $description = null)
	{
		$amount = $amount * 100;

		$charge = \Stripe\Charge::create(array(
			"amount" => $amount,
			"currency" => $currency,
			"description" => $description,
			"source" => $token,
		));

		$transaction = \Stripe\BalanceTransaction::retrieve($charge->balance_transaction);

		$source = $charge->source->id;
		$captured = $charge->captured ? "yes" : "no";
		$transaction_id = $charge->id;
		$fee = $transaction->fee / 100;
		$net = $transaction->net / 100;
		$currency = $transaction->currency;

		return (object) compact('source', 'transaction_id', 'captured', 'fee', 'net', 'currency');
	}
}
