<?php
/*
 * Plugin Name: WooCommerce PayCode
 * Plugin URI: https://paycode.com.mx/
 * Description: Paycode para WooCommerce compatible con pago mediante tarjeta de crédito / débito.
 * Author: PayCode
 * Author URI: https://paycode.com.mx/
 * Version: 1.2
 */

add_filter( 'woocommerce_payment_gateways', 'paycode_add_gateway_class' );
function paycode_add_gateway_class( $gateways ) {
	$gateways[] = 'wc_paycode_gateway_cc';
	return $gateways;
}

add_action( 'plugins_loaded', 'paycode_init_gateway_class' );

function paycode_init_gateway_class() {

	class wc_paycode_gateway_cc extends WC_Payment_Gateway {
 		public function __construct() {
      $this->id = 'paycode_cc';
      $this->icon = '';
      $this->has_fields = true;
      $this->method_title = 'PayCode – Cobro con tarjeta';
      $this->method_description = 'Paycode para WooCommerce compatible con pago con tarjeta de crédito / débito.';
      $this->supports = array(
        'products'
      );

      $this->init_form_fields();
      $this->init_settings();
      $this->title = $this->get_option( 'title' );
      $this->description = $this->get_option( 'description' );
      $this->enabled = $this->get_option( 'enabled' );
      $this->testmode = 'yes' === $this->get_option( 'testmode' );
      $this->api_key = $this->get_option( 'api_key' );

      add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
      add_action( 'wp_enqueue_scripts', array( $this, 'payment_scripts' ) );

 		}

 		public function init_form_fields(){
      $this->form_fields = array(
        'enabled' => array(
          'title'       => 'Activar / Desactivar',
          'label'       => 'Activar forma de pago',
          'type'        => 'checkbox',
          'description' => '',
          'default'     => 'no'
        ),
        'testmode' => array(
          'title'       => 'Modo',
          'label'       => 'Activar modo desarrollo?',
          'type'        => 'checkbox',
          'description' => 'Activa modo sandbox para realizar transacciones de prueba.',
          'default'     => 'no',
          'desc_tip'    => true,
        ),
        'title' => array(
          'title'       => 'Nombre de la forma de Pago',
          'type'        => 'text',
          'description' => 'Personaliza el nombre de la forma de pago',
          'default'     => 'Paga con Tarjeta de Crédito / Débito',
          'desc_tip'    => true,
        ),
        'description' => array(
          'title'       => 'Descripción',
          'type'        => 'textarea',
          'description' => 'Personaliza el mensaje a mostrar cuando el usuario seleccione el método de pago.',
          'default'     => 'Ingresa tu información de tarjeta de crédito / débito.',
        ),
        'api_key' => array(
          'title'       => 'Token API',
          'type'        => 'text'
        )
      );
	
	 	}

		public function payment_fields() {
      if ( $this->description ) {
        $sandbox_message = '';

        if ( empty( $this->api_key ) ) {
          return;
        }

        if ( $this->testmode ) {
          $sandbox_message = '<div class="paycode-cc-sandbox"><p class="paycode-cc-sandbox__title">Modo prueba activado!</p><p class="paycode-cc--sandbox__description">La forma de pago se encuentra en modo prueba, desactiva el modo si deseas realizar transacciones reales.</p></div>';
          $this->description  = trim( $this->description );
        }
        echo wpautop( wp_kses_post($sandbox_message . $this->description ) );
      }
    
      echo '<fieldset id="wc-' . esc_attr( $this->id ) . '-form" class="paycode-cc-wrapper">';
    
      do_action( 'woocommerce_credit_card_form_start', $this->id );
    
      echo '
        <div class="paycode-cc-form">
          <div class="paycode-cc-form__input">
            <label>Número de Tarjeta<span class="required">*</span></label>
            <small id="paycode_cc_amex" class="paycode-cc-amex">De momento no es posible hacer pagos usando tarjetas AMEX, intenta con alguna otra tarjeta.</small>
            <input id="paycode_cc_number" class="paycode-cc-number" type="text" name="paycode_cc_number" autocomplete="off">
          </div>
          <div class="paycode-cc-form__input paycode-cc--half-input paycode-cc--first">
            <label>Nombre(s) <span class="required">*</span></label>
            <input id="paycode_cc_name" class="" type="text" name="paycode_cc_name" autocomplete="off">
          </div>
          <div class="paycode-cc-form__input paycode-cc--half-input paycode-cc--last">
            <label>Apellidos <span class="required">*</span></label>
            <input id="paycode_cc_last_name" class="" type="text" name="paycode_cc_last_name" autocomplete="off">
          </div>
          <div class="paycode-cc-form__input paycode-cc--half-input paycode-cc--first">
            <label>Fecha de Expiración <span class="required">*</span></label>
            <input id="paycode_cc_exp" class="" type="text" autocomplete="off" placeholder="MM/YY" name="paycode_cc_exp" autocomplete="off">
          </div>
          <div class="paycode-cc-form__input paycode-cc--half-input paycode-cc--last">
            <label>CVC<span class="required">*</span></label>
            <input id="paycode_cvc" class="" type="password" placeholder="CVC" name="paycode_cc_cvc" autocomplete="off">
          </div>
        </div>
        <div class="paycode-cc-form-footer">Impulsado por <img src="'. plugins_url('assets/images/logo-paycode.png', __FILE__ ) .'"></div>
      ';
    
      do_action( 'woocommerce_credit_card_form_end', $this->id );
    
      echo '</fieldset>';
		}

	 	public function payment_scripts() {

      if ( ! is_cart() && ! is_checkout() && ! isset( $_GET['pay_for_order'] ) ) {
        return;
      }

      if ( 'no' === $this->enabled ) {
        return;
      }

      if ( empty( $this->api_key ) ) {
        return;
      }


      wp_register_style( 'woocommerce_paycode', plugins_url('assets/css/paycode_cc.css',__FILE__ ) );
      wp_enqueue_script( 'cleave_js', plugins_url('assets/js/libs/cleave.min.js', __FILE__));
      wp_enqueue_script( 'cleave_phone_js', plugins_url('assets/js/libs/addons/cleave-phone.mx.js', __FILE__));
      wp_register_script( 'woocommerce_paycode', plugins_url('assets/js/paycode_cc.js', __FILE__ ), array('cleave_js', 'cleave_phone_js' ), true);
      wp_enqueue_script('jquery');
      wp_enqueue_style( 'woocommerce_paycode' );
      wp_enqueue_script( 'woocommerce_paycode' );

	 	}

		public function validate_fields() {
      $need_human_verification = false;

      if( empty( $_POST[ 'paycode_cc_number' ]) ) {
      $need_human_verification = true;
        wc_add_notice(  'Numero de tarjeta es requerido. ' . $_POST[ 'paycode_cc_number' ] . ' :(', 'error' );
        // return false;
      }

      if( empty( $_POST[ 'paycode_cc_name' ]) ) {
        $need_human_verification = true;
        wc_add_notice(  'Nombre completo es requerido.', 'error' );
        // return false;
      }

      if( empty( $_POST[ 'paycode_cc_last_name' ]) ) {
        $need_human_verification = true;
        wc_add_notice(  'Nombre completo es requerido.', 'error' );
        // return false;
      }

      if( empty( $_POST[ 'paycode_cc_exp' ]) ) {
        $need_human_verification = true;
        wc_add_notice(  'Fecha de expiración es requerido.', 'error' );
        // return false;
      }

      if( empty( $_POST[ 'paycode_cc_cvc' ]) ) {
        $need_human_verification = true;
        wc_add_notice(  'CVC es requerido.', 'error' );
        // return false;
      }

      if( empty( $_POST[ 'billing_phone' ]) ) {
        $need_human_verification = true;
        wc_add_notice(  'Teléfono es requerido.', 'error' );
        // return false;
      }

      if( strlen($_POST[ 'billing_phone' ]) > 10 ) {
        $need_human_verification = true;
        wc_add_notice(  'Longitud de Teléfono invalida, necesitan ser 10 digitos.', 'error' );
        // return false;
      }

      if ($need_human_verification == false) {
        return true;
      } else {
        return false;
      }

		}

		public function process_payment( $order_id ) {
      global $woocommerce;
    
      $order = wc_get_order( $order_id );
    
      $cc_number = str_replace(" ", "", $_POST[ 'paycode_cc_number' ]);
      $cc_exp_raw = explode('/', $_POST[ 'paycode_cc_exp' ]);
      $cc_cvc = $_POST[ 'paycode_cc_cvc' ];
      $card_name = $_POST[ 'paycode_cc_name' ];
      $card_lastname = explode(' ', $_POST[ 'paycode_cc_last_name' ] );
      $order_total = number_format($order->get_total(), 2);
      $billing_phone = $_POST[ 'billing_phone' ];

      $args_login = array(
        'method' => 'GET',
        'headers' => array(
          'Authorization' => $this->api_key
        )
      );

      if ( $this->testmode == 1 ) {
        $login = wp_remote_post( 'https://dev.paycode.com.mx/Api/v2/auth/login', $args_login );
      } else {
        $login = wp_remote_post( 'https://plataforma.paycode.com.mx/Api/v2/auth/login', $args_login );
      }

      $credentials = json_decode( $login['body'], true );
    
      $body_array = array(
        'amount' => $order_total,
        'card' => array(
          'card_number' => $cc_number,
          'sec_code' => $cc_cvc,
          'exp_month' => $cc_exp_raw[0],
          'exp_year' => $cc_exp_raw[1],
          'cardholder_name' => $card_name . ' ' . $card_lastname[0] . ' ' . $card_lastname[1]
        ),
        'client' => array(
          'num_cel' => $billing_phone,
          'first_name' => $card_name,
          'paternal_surname' => $card_lastname[0],
          'maternal_surname' => $card_lastname[1],
          'concept' => 'PayCode - Cobro con tarjeta'
        )
      );

      $body = wp_json_encode($body_array);

      $args = array(
        'method' => 'POST',
        'headers' => array(
          'Content-Type' => 'application/json',
          'Authorization' => 'Bearer ' . $credentials['access_token']
        ),
        'body' => $body
      );

      if ( $this->testmode == 1 ) {
        $execute_payment = wp_remote_post( 'https://dev.paycode.com.mx/Api/v2/cobros/pago_tarjeta_ecomerce', $args );
      } else {
        $execute_payment = wp_remote_post( 'https://plataforma.paycode.com.mx/Api/v2/cobros/pago_tarjeta_ecomerce', $args );
      }
    
      if( !is_wp_error( $execute_payment ) ) {
    
        $body = json_decode( $execute_payment['body'], true );

        $body_string = json_encode($body, JSON_PRETTY_PRINT);

        if ( $body['success'] == true ) {    
          $order->payment_complete();
          $order->reduce_order_stock();
          $order->add_order_note( 'Pago procesado exitosamente mediante PayCode con el num. de referencía: '. $body['reference_number'], true );
          $woocommerce->cart->empty_cart();
          return array(
            'result' => 'success',
            'redirect' => $this->get_return_url( $order )
          );
    
        } else {

          if ($body['resultado'] == -1610) {
            wc_add_notice( 'Error: Nombre del tarjetahabiente incompletos, complementa tu información e intenta nuevamente. Código de error: ', 'error' );
            return;
          } elseif ($body['resultado'] == -1585) {
            wc_add_notice( 'Error: Número de tarjeta no válido. Código de error: ', 'error' );
            return;
          } else {
            wc_add_notice( 'Error: Intenta nuevamente o cambia tu forma de pago. Ningún cargo fue aplicado a tu tarjeta de crédito / débito. Código de error: ' . $body['resultado'], 'error' );
            return;
          }
          
        }
    
      } else {
        wc_add_notice( 'Error de conexión, intenta nuevamente o cambia tu forma de pago. Ningún cargo fue aplicado a tu tarjeta de crédito / débito. Código de error: ' . $body['resultado'], 'error' );
        return;
      }
					
	 	}

 	}

}